<?php
    include "../../db/connection.php";

    $subscription_id = isset($_GET['subscription_id']) ? $_GET['subscription_id'] : '';
    $back_url = 'subscription_list.php';
    
    $row1 = [];
    $query1 = "SELECT id, subscription_id, subscription_type, amount, ads, downloads, no_devices, no_days 
                FROM subscription 
                WHERE subscription_id = '$subscription_id'";
    $result1 = mysqli_query($conn, $query1);
    if ($result1 && mysqli_num_rows($result1) > 0) {
        $row1 = mysqli_fetch_assoc($result1);
    } 
    
    $selectedDevices = [];
    $query2 = "SELECT id, device_id FROM subscription_devices WHERE subscription_id = '$subscription_id' AND deletion = 0";
    $result2 = mysqli_query($conn, $query2);
    if ($result2 && mysqli_num_rows($result2) > 0) {
        while ($rowdept = mysqli_fetch_assoc($result2)) {
            $selectedDevices[] = $rowdept['device_id'];
        }
    }
    
    $selectedResolutions = [];
    $query3 = "SELECT id, resolution_id FROM subscription_resolutions WHERE subscription_id = '$subscription_id' AND deletion = 0";
    $result3 = mysqli_query($conn, $query3);
    if ($result3 && mysqli_num_rows($result3) > 0) {
        while ($rowcity = mysqli_fetch_assoc($result3)) {
            $selectedResolutions[] = $rowcity['resolution_id'];
        }
    }
    
    if (empty($row1)) {
        $savetype = "add_subscription";
    } else {
        $savetype = "edit_subscription";
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tundra Play</title>

    <?php include "../support_header.php"; ?>
    <link rel="stylesheet" href="../../assets/custom_css/other_styles.css">
</head>
<body>
    <div class="wrapper">
        <form id="saveForm" onsubmit="return add_form()" method="post" enctype="multipart/form-data">
            <div class="app-content-header">
                <div class="row">
                    <div class="col-6"><div class="heading">Save Subscription</div></div>
                    <div class="col-6 text-right">
                        <button type="submit" class="btn btn-primary mr-2" name="submit">Save</button>
                        <a class="btn btn-secondary" href="<?php echo $back_url; ?>">Back</a>
                    </div>
                </div>
            </div>
            <div class="app-content">
                <div class="card">

                    <input type="hidden" id="save_type" name="save_type" class="form-control" value="<?php echo $savetype; ?>" />
                    <input type="hidden" id="subscription_id" name="subscription_id" class="form-control" value="<?php echo $row1['subscription_id'] ?? ''; ?>" />

                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Subscription</span>
                                    </div>
                                    <input type="text" class="form-control" name="subscription_type" id="subscription_type" value="<?php echo $row1['subscription_type'] ?? ''; ?>">
                                </div>
                                <div class="error" id="subscription_type_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Amount</span>
                                    </div>
                                    <input type="text" class="form-control" name="amount" id="amount" value="<?php echo $row1['amount'] ?? ''; ?>">
                                </div>
                                <div class="error" id="amount_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Ads</span>
                                    </div>
                                    <div class="form-control">
                                        <label class="form-check-label" for="ads" style="display:flex; align-items:center;">
                                        <input class="form-check-input mr-3" type="checkbox" value="yes" id="ads" name="ads" <?php echo (($row1['ads'] ?? '') === 'yes') ? 'checked' : ''; ?> >
                                            Allow Ads
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Downloads</span>
                                    </div>
                                    <div class="form-control">
                                        <label class="form-check-label" for="downloads" style="display:flex; align-items:center;">
                                        <input class="form-check-input mr-3" type="checkbox" value="yes" id="downloads" name="downloads" <?php echo (($row1['downloads'] ?? '') === 'yes') ? 'checked' : ''; ?> >
                                            Allow Downloads
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">No of Devices</span>
                                    </div>
                                    <input type="text" class="form-control" name="no_devices" id="no_devices" value="<?php echo $row1['no_devices'] ?? ''; ?>">
                                </div>
                                <div class="error" id="no_devices_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">No of Days</span>
                                    </div>
                                    <input type="text" class="form-control" name="no_days" id="no_days" value="<?php echo $row1['no_days'] ?? ''; ?>">
                                </div>
                                <div class="error" id="no_days_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Devices</span>
                                    </div>
                                    <select class="form-control selectpicker select2" name="device_id" id="device_id" data-live-search="true" multiple>
                                        <?php
                                            $sql = "SELECT device_id, device_type FROM device WHERE deletion = 0";
                                            $res = mysqli_query($conn, $sql);
                                            if ($res && mysqli_num_rows($res) > 0) {
                                                while ($row = mysqli_fetch_assoc($res)) {
                                                    $selected = (in_array($row['device_id'], $selectedDevices)) ? 'selected' : '';
                                        ?>
                                                    <option value="<?php echo $row['device_id'] ?? ''; ?>" <?php echo $selected; ?> ><?php echo $row['device_type'] ?? ''; ?></option>
                                        <?php
                                                }
                                            }
                                        ?>
                                        <option value=""></option>
                                    </select>
                                </div>
                                <div class="error" id="device_id_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Resolutions</span>
                                    </div>
                                    <select class="form-control selectpicker select2" name="resolution_id" id="resolution_id" data-live-search="true" multiple>
                                        <?php
                                            $sql = "SELECT resolution_id, resolution_type FROM resolution WHERE deletion = 0";
                                            $res = mysqli_query($conn, $sql);
                                            if ($res && mysqli_num_rows($res) > 0) {
                                                while ($row = mysqli_fetch_assoc($res)) {
                                                    $selected = (in_array($row['resolution_id'], $selectedResolutions)) ? 'selected' : '';
                                        ?>
                                                    <option value="<?php echo $row['resolution_id'] ?? ''; ?>" <?php echo $selected; ?> ><?php echo $row['resolution_type'] ?? ''; ?></option>
                                        <?php
                                                }
                                            }
                                        ?>
                                        <option value=""></option>
                                    </select>
                                </div>
                                <div class="error" id="password_error"></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>

    <?php include "../support_footer.php"; ?>

    <script> 
        function add_form() {
            
            $('.error').html('');
            var url = "<?php echo $back_url;?>";
            var save_type = $("#save_type").val().trim();
            var subscription_id = $("#subscription_id").val().trim();
            var subscription_type = $("#subscription_type").val().trim();
            var amount = $("#amount").val().trim();
            var ads = $("#ads").is(":checked") ? "yes" : "no";
            var downloads = $("#downloads").is(":checked") ? "yes" : "no";
            var no_devices = $("#no_devices").val().trim();
            var no_days = $("#no_days").val().trim();
            var device_id = $("#device_id").val();
            var resolution_id = $("#resolution_id").val();
            
            var count = 0;
            
            if (count > 0) return false;

            var formData = new FormData();
            formData.append("type", save_type); 
            formData.append("subscription_id", subscription_id); 
            formData.append("subscription_type", subscription_type);  
            formData.append("amount", amount);  
            formData.append("ads", ads);  
            formData.append("downloads", downloads);  
            formData.append("no_devices", no_devices);  
            formData.append("no_days", no_days);  
            if (device_id.length > 0) {
                for (var i = 0; i < device_id.length; i++) {
                    formData.append("device_ids[]", device_id[i]);
                }
            }
            if (resolution_id.length > 0) {
                for (var i = 0; i < resolution_id.length; i++) {
                    formData.append("resolution_ids[]", resolution_id[i]);
                }
            }
            
            // for (var pair of formData.entries()) {
            //     console.log(pair[0] + ': ' + pair[1]);
            // }
            
            $.ajax({
                type: "POST",
                url: "setting_function.php",
                data: formData,
                processData: false, 
                contentType: false, 
                dataType: "json",
                success: function (response) {
                    // console.log("Server response:", response);
                    // alert(JSON.stringify(response));

                    if (response.status === 'success' && response.code === 11) {
                        alert("Successfully Saved!");
                    } else if (response.status === 'exists' || response.status === 'extension_error') {
                        alert(response.message);
                    } else if (response.status === 'error') {
                        $('.error').html(''); 
                        if (response.errors && response.errors.length > 0) {
                            response.errors.forEach(function(field) {
                                $('#' + field + '_error').html('*Required');
                            });
                        }
                    } else {
                        alert(response.message || "Not Added!");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    alert("Server Error: " + error);
                }
            });

            return false;
        }
    </script>

</body>
</html>