<?php
session_set_cookie_params([
    'lifetime' => 0,                  // Session ends when browser closes
    'path' => '/',
    'domain' => '',                   // Use current domain
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on', // Only HTTPS
    'httponly' => true,               // JS cannot access session cookie
    'samesite' => 'Strict'            // Protect against CSRF
]);

session_start();

// Regenerate session ID once per login
if (!isset($_SESSION['regenerated'])) {
    session_regenerate_id(true);
    $_SESSION['regenerated'] = true;

    // Save browser + IP fingerprint at login
    $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
    $_SESSION['ip'] = $_SERVER['REMOTE_ADDR']; // optional
}

$session_id = session_id();

include('../db/connection.php');

date_default_timezone_set("Asia/Kolkata");
$datetime = date("Y-m-d H:i:s");

$ipaddress=$_SERVER['REMOTE_ADDR'];

// $browser_name=$_SERVER['HTTP_USER_AGENT'];
if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)
    $browser_name = 'Internet explorer';
elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== false)
    $browser_name = 'Internet explorer';
elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox') !== false)
    $browser_name = 'Mozilla Firefox';
elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false)
    $browser_name = 'Google Chrome';
elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera Mini') !== false)
    $browser_name = "Opera Mini";
elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') !== false)
    $browser_name = "Opera";
elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Safari') !== false)
    $browser_name = "Safari";
else
    $browser_name = 'Other';
   
// CSRF check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    echo "CSRF Error";
    exit;
}

$email = trim($_POST['email'] ?? '');
$password_input = trim($_POST['password'] ?? '');

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo "Invalid Email";
    exit;
}

// Fetch user details by email only
$stmt = $conn->prepare("
    SELECT 
        id, user_id, email_id, name, 
        mobile, role, password, status 
    FROM user 
    WHERE deletion = 0 
      AND email_id = ?
");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $stored_hash = $row['password'];

    // Verify password
    if (password_verify($password_input, $stored_hash)) {
        
        $user_id = $row['user_id'];
        $user_email = $row['email_id'];
        $user_verified = $row['status'];

        $_SESSION['tundra_email_id']  = $row['email_id'];
        $_SESSION['tundra_user_name']  = $row['name'];
        $_SESSION['tundra_user_id']   = $row['user_id'];
        $_SESSION['tundra_role']   = $row['role'];
        $_SESSION['tundra_mobile']   = $row['mobile'];
        $_SESSION['tundrastarttimeout'] = time();
        
         ///$audit_trailobj->insert_login_details($user_id,$ipaddress,$datetime,$browser_name,$user_email);
         
        if (strtolower($user_verified) == 'active') {
            echo "true_login"; 
        } else {
            echo "verification_progress"; 
        }
    } else {
        echo "false_login 1"; // wrong password
    }
} else {
    echo "false_login 2"; // no user found
}

$stmt->close();
?>
