<?php
    include "../../db/connection.php";

    $subscription_id = $_POST['subscription_id'] ?? '';

    if ($subscription_id == '') {
        echo json_encode(['status' => 'Subscription ID is empty..!']);
        exit;
    }

    $sql = "SELECT no_days FROM subscription WHERE subscription_id = ? AND deletion = 0";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $subscription_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        echo json_encode([
            'status' => 'success',
            'no_days' => (int)$row['no_days']
        ]);
    } else {
        echo json_encode(['status' => 'Unable to fetch No of Days of Subscription..!']);
    }
?>