<?php
    include "../../db/connection.php";

    // $login_user_id = $_SESSION['tundra_user_id'];
    // $login_role = $_SESSION['tundra_role'];

    $login_user_id = "USER_1";
    $login_role = "admin";

    $type = $_POST['type'];

    date_default_timezone_set("Asia/Kolkata");
    $currentdatetime = date("Y-m-d H:i:s");
    $currentdate = date("Y-m-d");
    $currenttime = date("H-i-s");

    if ($type == 'add_user') {
        $errors = [];

        $user_id       = trim($_POST['user_id'] ?? '');
        $user_name       = trim($_POST['user_name'] ?? '');
        $email_id       = trim($_POST['email_id'] ?? '');
        $mobile       = trim($_POST['mobile'] ?? '');
        $password       = trim($_POST['password'] ?? '');
        $subscription_id       = trim($_POST['subscription_id'] ?? '');
        $subs_start_date       = trim($_POST['subs_start_date'] ?? '');
        $subs_end_date       = trim($_POST['subs_end_date'] ?? '');

        if ($user_name === '') { $errors[] = 'user_name'; }
        if ($email_id === '') { $errors[] = 'email_id'; }
        if ($mobile === '') { $errors[] = 'mobile'; }
        if ($password === '') { $errors[] = 'password'; }
        if ($subscription_id === '') { $errors[] = 'subscription_id'; }
        if ($subs_start_date === '') { $errors[] = 'subs_start_date'; }
        if ($subs_end_date === '') { $errors[] = 'subs_end_date'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM user 
                        WHERE deletion = 0 
                            AND (email_id = ? OR mobile = ?)";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("ss", $email_id, $mobile);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // --- Insert new record ---
        $insert_sql = "INSERT INTO user (user_id, name, email_id, mobile, password, subscription_id, subs_start_date, 
                            subs_end_date, role, added_by, added_time)
                        VALUES ('NA', ?, ?, ?, ?, ?, ?, ?, 'publisher', ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sssssssss",
            $user_name,
            $email_id,
            $mobile,
            $hashed_password,
            $subscription_id,
            $subs_start_date,
            $subs_end_date,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $user_id = 'USER_' . $last_id;
            
            $update_sql = "UPDATE user 
                        SET user_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$user_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_user') {
        $errors = [];

        $user_id       = trim($_POST['user_id'] ?? '');
        $user_name       = trim($_POST['user_name'] ?? '');
        $email_id       = trim($_POST['email_id'] ?? '');
        $mobile       = trim($_POST['mobile'] ?? '');
        $password       = trim($_POST['password'] ?? '');
        $subscription_id       = trim($_POST['subscription_id'] ?? '');
        $subs_start_date       = trim($_POST['subs_start_date'] ?? '');
        $subs_end_date       = trim($_POST['subs_end_date'] ?? '');

        if ($user_id === '') { $errors[] = 'user_name'; }
        if ($user_name === '') { $errors[] = 'user_name'; }
        if ($email_id === '') { $errors[] = 'email_id'; }
        if ($mobile === '') { $errors[] = 'mobile'; }
        if ($password === '') { $errors[] = 'password'; }
        if ($subscription_id === '') { $errors[] = 'subscription_id'; }
        if ($subs_start_date === '') { $errors[] = 'subs_start_date'; }
        if ($subs_end_date === '') { $errors[] = 'subs_end_date'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE user 
                    SET name = ?, email_id = ?, mobile = ?, subscription_id = ?, subs_start_date = ?, subs_end_date = ? 
                    WHERE user_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("sssssss",$user_name,$email_id,$mobile,$subscription_id,$subs_start_date,$subs_end_date, $user_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_user') {
        $id = $_POST['id'];
        $sql = "UPDATE user SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE user_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
?>