<?php
    include "../../db/connection.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tundra Play</title>

    <?php include "../support_header.php"; ?>
    <link rel="stylesheet" href="../../assets/custom_css/other_styles.css">
</head>
<body>
    <div class="wrapper">
        <div class="app-content-header">
            <div class="row">
                <div class="col-6"><div class="heading">Users</div></div>
                <div class="col-6 text-right">
                    <a href="user_save.php" class="btn btn-primary mr-2">+ User</a>
                    <a class="btn btn-secondary" href="../dashboard.php">Back</a>
                </div>
            </div>
        </div>
        <div class="app-content">
            <div class="card">
                <div class="datatableContainer">
                    <table id="datatable-response" class="dataTable">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Name</th>
                                <th>Email ID</th>
                                <th>Mobile</th>
                                <th>Subcription</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Status</th>
                                <th>Added Time</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $sql = "SELECT u.id, u.user_id, u.name, u.email_id, u.mobile, u.subscription_id, s.subscription_type, 
                                            u.subs_start_date, u.subs_end_date, u.role, u.status, u.added_time 
                                        FROM user u 
                                        LEFT JOIN subscription s ON s.subscription_id = u.subscription_id 
                                        WHERE u.deletion = 0";
                                $res = mysqli_query($conn, $sql);
                                if ($res && mysqli_num_rows($res) > 0) {
                                    $sno = 1;
                                    while ($row = mysqli_fetch_assoc($res)) {
                            ?>
                                        <tr>
                                            <td><?php echo $sno; ?></td>
                                            <td><?php echo $row['name']; ?></td>
                                            <td><?php echo $row['email_id']; ?></td>
                                            <td><?php echo $row['mobile']; ?></td>
                                            <td><?php echo $row['subscription_type']; ?></td>
                                            <td><?php echo $row['subs_start_date']; ?></td>
                                            <td><?php echo $row['subs_end_date']; ?></td>
                                            <td><?php echo $row['status']; ?></td>
                                            <td><?php echo $row['added_time']; ?></td>
                                            <td>
                                                <div class="action-dot"><i class="fa fa-ellipsis-v"></i>
                                                    <div class="menu-box">
                                                        <ul class="p-0 m-0">
                                                            <li class="menu-item"><a href="user_save.php?user_id=<?php echo $row['user_id']; ?>">Edit</a></li>
                                                            <li class="menu-item"><a href="javascript:void(0)" data-id="<?php echo $row['user_id']; ?>" id="deletemenu">Delete</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                            <?php
                                        $sno++;
                                    }
                                }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include "../support_footer.php"; ?>

    <script>
        $('#datatable-response').DataTable({
            responsive: true,
            autoWidth: false,
            scrollX: false,
            dom: '<"top d-flex justify-content-between"lBf>rt<"bottom d-flex justify-content-between"ip><"clear">',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print', 'colvis'],
            columnDefs: [
                { responsivePriority: 1, targets: -1 }
            ]
        });        
    </script>
    
    <script>
        $(document).on("click","#deletemenu",function(){
            var id=$(this).data("id");
            $("#staticBackdrop").modal("show");
            document.getElementById('okbutton').setAttribute('onclick','delbtn("'+id+'")');
            $("#staticBackdrop .confirmation p").html("Are you sure to Delete?");
        });
        
        function delbtn(id) {
            var type="delete_genre";
            $.ajax({
                type: "POST",
                url: "user_function.php",
                data: {type:type,id:id},
                async: false,
                success: function(response) {
                    //alert(response);
                    if(response==11) {
                        $("#staticBackdrop").modal("hide");
                        $("#successalertmodal").modal("show");
                        $("#successalertmodal .confirmation p").html("Successfully Deleted!");
                        $("#successok").attr("href",url);
                    } else {
                        $("#staticBackdrop").modal("hide");
                        $("#erroralertmodal").modal("show");
                        $("#erroralertmodal .confirmation p").html("Not Deleted!");
                    }
                }
            });
            return false;
        }
    </script>

</body>
</html>