<?php
    include "../../db/connection.php";

    $user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';
    $back_url = 'user_list.php';

    date_default_timezone_set("Asia/Kolkata");
    $currentdate = date("Y-m-d");
    
    $row1 = [];
    $query1 = "SELECT id, user_id, name, email_id, mobile, password, subscription_id, subs_start_date, subs_end_date 
                FROM user 
                WHERE user_id = '$user_id'";
    $result1 = mysqli_query($conn, $query1);
    if ($result1 && mysqli_num_rows($result1) > 0) {
        $row1 = mysqli_fetch_assoc($result1);
    } 
    
    if (empty($row1)) {
        $savetype = "add_user";
    } else {
        $savetype = "edit_user";
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tundra Play</title>

    <?php include "../support_header.php"; ?>
    <link rel="stylesheet" href="../../assets/custom_css/other_styles.css">
</head>
<body>
    <div class="wrapper">
        <form id="saveForm" onsubmit="return add_form()" method="post" enctype="multipart/form-data">
            <div class="app-content-header">
                <div class="row">
                    <div class="col-6"><div class="heading">Save User</div></div>
                    <div class="col-6 text-right">
                        <button type="submit" class="btn btn-primary mr-2" name="submit">Save</button>
                        <a class="btn btn-secondary" href="<?php echo $back_url; ?>">Back</a>
                    </div>
                </div>
            </div>
            <div class="app-content">
                <div class="card">

                    <input type="hidden" id="save_type" name="save_type" class="form-control" value="<?php echo $savetype; ?>" />
                    <input type="hidden" id="user_id" name="user_id" class="form-control" value="<?php echo $row1['user_id'] ?? ''; ?>" />

                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Name</span>
                                    </div>
                                    <input type="text" class="form-control" name="user_name" id="user_name" value="<?php echo $row1['name'] ?? ''; ?>">
                                </div>
                                <div class="error" id="user_name_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Email ID</span>
                                    </div>
                                    <input type="email" class="form-control" name="email_id" id="email_id" value="<?php echo $row1['email_id'] ?? ''; ?>">
                                </div>
                                <div class="error" id="email_id_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Mobile</span>
                                    </div>
                                    <input type="text" class="form-control" name="mobile" id="mobile" value="<?php echo $row1['mobile'] ?? ''; ?>">
                                </div>
                                <div class="error" id="mobile_error"></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Password</span>
                                    </div>
                                    <input type="text" class="form-control" name="password" id="password" value="" readonly>
                                </div>
                                <div class="error" id="password_error"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Subscription</span>
                                    </div>
                                    <select class="form-control" name="subscription_id" id="subscription_id">
                                        <option value="" selected></option>
                                        <?php
                                            $sql = "SELECT subscription_id, subscription_type FROM subscription WHERE deletion = 0";
                                            $res = mysqli_query($conn, $sql);
                                            if ($res && mysqli_num_rows($res) > 0) {
                                                while ($row = mysqli_fetch_assoc($res)) {
                                                    $selected = ($row['subscription_id'] == $row1['subscription_id']) ? 'selected' : '';
                                        ?>
                                                    <option value="<?php echo $row['subscription_id'] ?? ''; ?>" <?php echo $selected; ?> ><?php echo $row['subscription_type'] ?? ''; ?></option>
                                        <?php
                                                }
                                            }
                                        ?>
                                    </select>
                                </div>
                                <div class="error" id="password_error"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Start Date</span>
                                    </div>
                                    <input type="date" class="form-control" name="subs_start_date" id="subs_start_date" value="<?php echo $row1['subs_start_date'] ?? $currentdate; ?>">
                                </div>
                                <div class="error" id="password_error"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">End Date</span>
                                    </div>
                                    <input type="date" class="form-control" name="subs_end_date" id="subs_end_date" value="<?php echo $row1['subs_end_date'] ?? ''; ?>">
                                </div>
                                <div class="error" id="subs_end_date_error"></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>

    <?php include "../support_footer.php"; ?>

    <script> 
        function add_form() {
            
            $('.error').html('');
            var url = "<?php echo $back_url;?>";
            var save_type = $("#save_type").val().trim();
            var user_id = $("#user_id").val().trim();
            var user_name = $("#user_name").val().trim();
            var email_id = $("#email_id").val().trim();
            var mobile = $("#mobile").val().trim();
            var password = $("#password").val().trim();
            var subscription_id = $("#subscription_id").val().trim();
            var subs_start_date = $("#subs_start_date").val().trim();
            var subs_end_date = $("#subs_end_date").val().trim();
            
            var count = 0;

            // if (user_name == '') { $('#user_name_error').html('*Required'); count++; }
            // if (email_id == '') { $('#email_id_error').html('*Required'); count++; }
            // if (mobile == '') { $('#mobile_error').html('*Required'); count++; }
            // if (password == '') { $('#password_error').html('*Required'); count++; }
            // if (subscription_id == '') { $('#subscription_id_error').html('*Required'); count++; }
            // if (subs_start_date == '') { $('#subs_start_date_error').html('*Required'); count++; }
            // if (subs_end_date == '') { $('#subs_end_date_error').html('*Required'); count++; }
            
            if (count > 0) return false;

            var formData = new FormData();
            formData.append("type", save_type); 
            formData.append("user_id", user_id); 
            formData.append("user_name", user_name);  
            formData.append("email_id", email_id); 
            formData.append("mobile", mobile);  
            formData.append("password", password); 
            formData.append("subscription_id", subscription_id);  
            formData.append("subs_start_date", subs_start_date); 
            formData.append("subs_end_date", subs_end_date);  
            
            // for (var pair of formData.entries()) {
            //     console.log(pair[0] + ': ' + pair[1]);
            // }
            
            $.ajax({
                type: "POST",
                url: "user_function.php",
                data: formData,
                processData: false, 
                contentType: false, 
                dataType: "json",
                success: function (response) {
                    // console.log("Server response:", response);
                    // alert(JSON.stringify(response));

                    if (response.status === 'success' && response.code === 11) {
                        alert("Successfully Saved!");
                    } else if (response.status === 'exists' || response.status === 'extension_error') {
                        alert(response.message);
                    } else if (response.status === 'error') {
                        $('.error').html(''); 
                        if (response.errors && response.errors.length > 0) {
                            response.errors.forEach(function(field) {
                                $('#' + field + '_error').html('*Required');
                            });
                        }
                    } else {
                        alert(response.message || "Not Added!");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    alert("Server Error: " + error);
                }
            });

            return false;
        }
    
        function generatePassword() {
            var email = $("#email_id").val().trim().toLowerCase();
            var mobile = $("#mobile").val().trim();

            // Only generate when email ≥ 4 chars AND mobile ≥ 10 digits
            if (email.length >= 4 && mobile.length >= 10) {

                var emailPart = email.substring(0, 4);   // first 4 letters
                var mobilePart = mobile.slice(-4);       // last 4 digits

                $("#password").val(emailPart + mobilePart);
            } else {
                $("#password").val('');
            }
        }

        $("#email_id, #mobile").on("keyup blur", function () {
            generatePassword();
        });
    
        function calculateEndDate(no_days) {
            var startDate = $("#subs_start_date").val();

            if (!startDate || no_days <= 0) {
                $("#subs_end_date").val('');
                return;
            }

            var date = new Date(startDate);
            date.setDate(date.getDate() + parseInt(no_days));

            var yyyy = date.getFullYear();
            var mm = String(date.getMonth() + 1).padStart(2, '0');
            var dd = String(date.getDate()).padStart(2, '0');

            $("#subs_end_date").val(`${yyyy}-${mm}-${dd}`);
        }

        $("#subscription_id").on("change", function () {
            var subscription_id = $(this).val().trim();

            if (subscription_id === '') {
                $("#subs_end_date").val('');
                return;
            }

            $.ajax({
                type: "POST",
                url: "get_subscription_days.php",
                data: { subscription_id: subscription_id },
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        calculateEndDate(response.no_days);
                    } else {
                        alert(response.status);
                    }
                }
            });
        });
    </script>

</body>
</html>