<?php
session_set_cookie_params([
    'lifetime' => 0,                  // Session ends when browser closes
    'path' => '/',
    'domain' => '',                   // Use current domain
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on', // Only HTTPS
    'httponly' => true,               // JS cannot access session cookie
    'samesite' => 'Strict'            // Protect against CSRF
]);

session_start();

// Regenerate session ID once per login
if (!isset($_SESSION['regenerated'])) {
    session_regenerate_id(true);
    $_SESSION['regenerated'] = true;

    // Save browser + IP fingerprint at login
    $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
    $_SESSION['ip'] = $_SERVER['REMOTE_ADDR']; // optional
    
   
}

$session_id = session_id();

include('../db/connection.php');

date_default_timezone_set("Asia/Kolkata");
$date = date("Y-m-d H:i:s");	
	

$email = $_POST['email'] ?? '';
$otp   = $_POST['otp'] ?? '';

if (empty($email) || empty($otp)) {
    echo "33"; // invalid input
    exit;
}

// 1. OTP verification
$sql = "SELECT id 
        FROM login_otp_verification 
        WHERE active=0 
          AND otp=? 
          AND email=? 
          AND date >= NOW() - INTERVAL 5 MINUTE 
        ORDER BY date DESC 
        LIMIT 1";
        
      
        

$sql = "
    SELECT id 
    FROM login_otp_verification 
    WHERE active=0 
      AND otp=? 
      AND email=? 
      AND date >= DATE_SUB(?, INTERVAL 5 MINUTE) 
    ORDER BY id DESC 
    LIMIT 1
";
//echo $sql;
$stmt = $conn->prepare($sql);
$stmt->bind_param("sss", $otp, $email, $date);

$stmt->execute();
$result = $stmt->get_result();
$otp_row = $result->fetch_assoc();

if (!$otp_row) {
    echo "33"; // invalid or expired otp
    exit;
}

// Mark OTP as used
$update = $conn->prepare("UPDATE login_otp_verification SET active=1 WHERE id=?");
$update->bind_param("i", $otp_row['id']);
$update->execute();

// 2. Check user in signupdetails
$stmt = $conn->prepare("SELECT id, user_id, email_id, name, 
                            mobile, role, password, status 
                        FROM user 
                        WHERE deletion = 0 
                            AND email_id = ? 
                        LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if (!$user) {
    echo "false_login";
    exit;
}
else
{
    $otp_verification=$user['status'];
    if($otp_verification=='active')
    {
        
        $_SESSION['tundra_email_id']  = $user['email_id'];
        $_SESSION['tundra_user_name']  = $user['name'];
        $_SESSION['tundra_user_id']   = $user['user_id'];
        $_SESSION['tundra_role']   = $user['role'];
        $_SESSION['tundra_mobile']   = $user['mobile'];
        $_SESSION['tundrastarttimeout'] = time();
        
        echo "true_login";
    }
    else
    {
        echo "Please Do OTP Verification before login";
    }
}
?>
