package com.b2lmobitech.tundraplaynew

import android.os.Bundle
import android.util.Log
import android.widget.Button
import android.widget.EditText
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.gson.Gson
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class AddProfileActivity : AppCompatActivity() {

    private lateinit var etName: EditText
    private lateinit var rvLanguages: RecyclerView
    private lateinit var btnSave: Button

    private val languages = mutableListOf<Language>()
    private lateinit var adapter: LanguageAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_add_profile)

        etName = findViewById(R.id.etProfileName)
        rvLanguages = findViewById(R.id.rvLanguages)
        btnSave = findViewById(R.id.btnSaveProfile)

        rvLanguages.layoutManager = GridLayoutManager(this, 2)
        adapter = LanguageAdapter(languages)
        rvLanguages.adapter = adapter

        loadLanguages()

        btnSave.setOnClickListener { saveProfile() }
    }

    private fun loadLanguages() {
        RetrofitClient.api.getLanguages()
            .enqueue(object : Callback<LanguageResponse> {
                override fun onResponse(
                    call: Call<LanguageResponse>,
                    response: Response<LanguageResponse>
                ) {
                    if (response.isSuccessful && response.body()?.success == true) {
                        languages.clear()
                        languages.addAll(response.body()!!.languages)
                        adapter.notifyDataSetChanged()
                    }
                }

                override fun onFailure(call: Call<LanguageResponse>, t: Throwable) {
                    toast("Failed to load languages")
                }
            })
    }

    private fun saveProfile() {
        val name = etName.text.toString().trim()

        if (name.isEmpty()) {
            toast("Enter profile name")
            return
        }

        val selectedLangIds =
            languages.filter { it.selected }.map { it.language_id }

        if (selectedLangIds.isEmpty()) {
            toast("Select at least one language")
            return
        }

        val userId = SessionManager(this).getUserId().toString()
        val json = Gson().toJson(selectedLangIds)

        Log.d("userid","$userId, $json")
        RetrofitClient.api.addProfile(userId, name, json)
            .enqueue(object : Callback<ApiResponse> {
                override fun onResponse(
                    call: Call<ApiResponse>,
                    response: Response<ApiResponse>
                ) {
                    Log.d("here","here")
                    if (response.isSuccessful && response.body()?.success == true) {
                        toast("Profile added")
                        finish()
                    }
                    else {
                        toast("${response.body()!!.message}")
                    }
                }

                override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
                    toast("Failed to save profile")
                }
            })
    }

    private fun toast(msg: String) =
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show()
}
