package com.b2lmobitech.tundraplaynew

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

data class ApiResponse(
    val success: Boolean,
    val message: String,
    val user: User?
)

data class User(
    val id: String,
    val name: String,
    val email: String,
    val phone: String
)

@Parcelize
data class Movie(
    val id: String,
    val content_id: String,
    val title: String,
    val description: String,
    val release_date: String,
    val duration: String,
    val original_language: String,
    val age_rating: String?,
    val poster_vertical: String,
    val poster_horizontal: String,
    val original_filepath: String,
    val dash_filepath: String,
    val cid: String,
    val ckey: String,
    val status: String?,
    val added_by: String?,
    val added_time: String?,
    val deleted_by: String?,
    val deleted_time: String?,
    val deletion: String
): Parcelable

//data class Category(
//    val title: String,
//    val movies: List<Movie>,
//    val isFromServer: Boolean = false
//)

data class HomeResponse(
    val categories: List<Category>
)

data class Category(
    val playlist_id: String,
    val title: String,
    val type: String,
    val movies: List<Movie>
)

data class UserProfile(
    val id: Int,
    val profile_id: String,
    val profile_name: String,
    val role: String,      // adult / kids
    val isAdd: Boolean = false
)

data class ProfileResponse(
    val success: Boolean,
    val profiles: List<UserProfile>
)

data class Language(
    val id: Int,
    val language_id: String,
    val language_type: String,
    var selected: Boolean = false
)

data class LanguageResponse(
    val success: Boolean,
    val languages: List<Language>
)

data class SubscriptionPlan(
    val id: Int,
    val subscription_id: String,
    val subscription_type: String,
    val amount: String,
    val ads: String,
    val downloads: String,
    val no_devices: String,
    val no_days: String
)

data class SubscriptionResponse(
    val success: Boolean,
    val subscriptions: List<SubscriptionPlan>
)

data class UserResponse(
    val id: String,
    val user_id: String?,
    val name: String,
    val email_id: String,
    val mobile: String,
    val subscription_id: String?,
    val subs_start_date: String?,
    val subs_end_date: String?,
    val role: String?,
    val status: String?
)


