package com.b2lmobitech.tundraplaynew

import retrofit2.Call
import retrofit2.Response
import retrofit2.http.Field
import retrofit2.http.FormUrlEncoded
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface ApiService {

    @FormUrlEncoded
    @POST("login.php")
    fun login(
        @Field("email") email: String,
        @Field("password") password: String
    ): Call<ApiResponse>

    @FormUrlEncoded
    @POST("register.php")
    fun register(
        @Field("name") name: String,
        @Field("email") email: String,
        @Field("phone") phone: String,
        @Field("password") password: String,
        @Field("confirmPassword") confirmPassword: String
    ): Call<ApiResponse>

    @GET("top_picks.php")
    suspend fun getTopPicks(): Response<List<Movie>>

    @FormUrlEncoded
    @POST("verify_otp.php")
    fun verifyOtp(
        @Field("user_id") user_id: String,
        @Field("phone") phone: String,
        @Field("otp") otp: String
    ): Call<ApiResponse>

    @FormUrlEncoded
    @POST("login_mobile.php")
    fun loginWithMobile(
        @Field("phone") phone: String
    ): Call<ApiResponse>

    @FormUrlEncoded
    @POST("login_verify_otp.php")
    fun loginVerifyOtp(
        @Field("phone") phone: String,
        @Field("otp") otp: String
    ): Call<ApiResponse>

    @GET("home.php")
    suspend fun getHome(): Response<HomeResponse>

    @FormUrlEncoded
    @POST("get_user_profiles.php")
    fun getUserProfiles(
        @Field("user_id") userId: String
    ): Call<ProfileResponse>

    @POST("get_languages.php")
    fun getLanguages(): Call<LanguageResponse>

    @FormUrlEncoded
    @POST("add_profile.php")
    fun addProfile(
        @Field("user_id") userId: String,
        @Field("profile_name") name: String,
        @Field("languages") languagesJson: String
    ): Call<ApiResponse>

    @GET("get_subscriptions.php")
    fun getSubscriptions(): Call<SubscriptionResponse>

    @FormUrlEncoded
    @POST("subscribe_user.php")
    fun subscribeUser(
        @Field("user_id") userId: String,
        @Field("subscription_id") subscriptionId: String
    ): Call<ApiResponse>

    @GET("getUserById.php")
    fun getUserById(
        @Query("id") userId: String
    ): Call<UserResponse>

    // Get subscription details
    @GET("getSubscriptionById.php")
    fun getSubscriptionById(
        @Query("id") subscriptionId: String
    ): Call<SubscriptionPlan>

    @GET("searchMovies.php")
    fun searchMovies(
        @Query("q") query: String
    ): Call<List<Movie>>

}
