package com.b2lmobitech.tundraplaynew

import android.content.Context
import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide

class BannerAdapter(
    private val movies: List<Movie>
) : RecyclerView.Adapter<BannerAdapter.BannerVH>() {

    inner class BannerVH(view: View) : RecyclerView.ViewHolder(view) {
        val bannerImage: ImageView = view.findViewById(R.id.bannerImage)
        val btnWatchNow: Button = view.findViewById(R.id.btnWatchNow)
        val btnMyList: Button = view.findViewById(R.id.btnMyList)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BannerVH {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_banner, parent, false)
        return BannerVH(view)
    }

    override fun onBindViewHolder(holder: BannerVH, position: Int) {
        val movie = movies[position]
        val context = holder.itemView.context

        // Load horizontal poster
        Glide.with(context)
            .asBitmap()
            .load(movie.poster_horizontal)
            .into(holder.bannerImage)

        // Click banner → Movie details
        holder.itemView.setOnClickListener {
            openMovie(context, movie)
        }

        // Watch Now → Movie details
        holder.btnWatchNow.setOnClickListener {
            openMovie(context, movie)
        }

        // My List (placeholder – backend later)
        holder.btnMyList.setOnClickListener {
            // TODO: API call to add movie to user's list
            // showToast("Added to My List")
        }
    }

    override fun getItemCount(): Int = movies.size

    private fun openMovie(context: Context, movie: Movie) {
        val intent = Intent(context, MovieDetailsActivity::class.java)
        intent.putExtra("MOVIE", movie)
        context.startActivity(intent)
    }
}
