package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

class CategoryAdapter(
    private val categories: List<Category>
) : RecyclerView.Adapter<CategoryAdapter.CategoryViewHolder>() {

    inner class CategoryViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val title: TextView = view.findViewById(R.id.categoryTitle)
        val recycler: RecyclerView = view.findViewById(R.id.movieRecycler)

        init {
            recycler.layoutManager =
                LinearLayoutManager(view.context, RecyclerView.HORIZONTAL, false)
//            recycler.setHasFixedSize(true)
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): CategoryViewHolder {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_category, parent, false)
        return CategoryViewHolder(view)
    }

    override fun onBindViewHolder(holder: CategoryViewHolder, position: Int) {
        val category = categories[position]

        // Safety: skip banners if accidentally passed
        if (category.type.lowercase() == "banners") return

        holder.title.text = category.title

        holder.recycler.adapter =
            MovieVerticalAdapter(category.movies) { movie ->
                val context = holder.itemView.context
                val intent = Intent(context, MovieDetailsActivity::class.java)
                intent.putExtra("MOVIE", movie)
                context.startActivity(intent)
            }
    }

    override fun getItemCount(): Int = categories.size
}
