package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.widget.ImageView
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.viewpager2.widget.ViewPager2
import com.google.android.material.bottomnavigation.BottomNavigationView
import kotlinx.coroutines.launch
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayoutMediator


class HomeActivity : AppCompatActivity() {

    private lateinit var bannerPager: ViewPager2
    private lateinit var categoryRecycler: RecyclerView

    private val handler = Handler(Looper.getMainLooper())
    private var currentPage = 0

    private lateinit var bannerIndicator: TabLayout

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_home)

        // Bottom Navigation
        val bottomNav = findViewById<BottomNavigationView>(R.id.bottomNavigation)
        bottomNav.selectedItemId = R.id.nav_home

        bottomNav.setOnItemSelectedListener {
            when (it.itemId) {
                R.id.nav_home -> true
                R.id.nav_profile -> {
                    startActivity(Intent(this, ProfileActivity::class.java))
                    true
                }
                else -> false
            }
        }

        bannerIndicator = findViewById(R.id.bannerIndicator)

        // Top icons
        findViewById<ImageView>(R.id.ivSearch).setOnClickListener {
            startActivity(Intent(this, SearchActivity::class.java))
        }

        findViewById<ImageView>(R.id.ivNotification).setOnClickListener {}

        bannerPager = findViewById(R.id.bannerPager)

        categoryRecycler = findViewById(R.id.categoryRecycler)
        categoryRecycler.layoutManager = LinearLayoutManager(this)

        loadHome()
    }

    // ======================================================
    // LOAD HOME DATA
    // ======================================================
    private fun loadHome() {
        lifecycleScope.launch {
            try {
                val response = RetrofitClient.api.getHome()

                if (response.isSuccessful) {
                    val categories = response.body()?.categories ?: return@launch

                    //  Banner playlist
                    val bannerCategory =
                        categories.firstOrNull { it.type.lowercase() == "banners" }

                    bannerCategory?.let {
                        bannerPager.adapter = BannerAdapter(it.movies)
                        TabLayoutMediator(bannerIndicator, bannerPager) { tab, _ ->
                            tab.setCustomView(R.layout.item_dot_banner)
                        }.attach()
                        autoScrollBanner(it.movies.size)
                    }

                    //  Normal categories
                    val normalCategories =
                        categories.filter { it.type.lowercase() != "banners" }

                    categoryRecycler.adapter =
                        CategoryAdapter(normalCategories)

                } else {
                    Log.e("HOME_API", "Failed: ${response.code()}")
                }
            } catch (e: Exception) {
                Log.e("HOME_API", "Exception", e)
            }
        }
    }

    // ======================================================
    // AUTO SCROLL BANNER
    // ======================================================
    private fun autoScrollBanner(size: Int) {
        if (size <= 1) return

        handler.postDelayed(object : Runnable {
            override fun run() {
                currentPage = (currentPage + 1) % size
                bannerPager.setCurrentItem(currentPage, true)
                handler.postDelayed(this, 5000)
            }
        }, 5000)
    }
}
