package com.b2lmobitech.tundraplaynew

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CheckBox
import androidx.recyclerview.widget.RecyclerView

class LanguageAdapter(
    private val list: List<Language>
) : RecyclerView.Adapter<LanguageAdapter.VH>() {

    inner class VH(view: View) : RecyclerView.ViewHolder(view) {
        val check: CheckBox = view.findViewById(R.id.cbLanguage)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): VH {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_language, parent, false)
        return VH(view)
    }

    override fun onBindViewHolder(holder: VH, position: Int) {
        val lang = list[position]

        holder.check.text = lang.language_type
        holder.check.isChecked = lang.selected

        holder.check.setOnCheckedChangeListener { _, isChecked ->
            lang.selected = isChecked
        }
    }

    override fun getItemCount() = list.size
}
