package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.Button
import android.widget.EditText
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class Login : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val session = SessionManager(this)
        if (session.isLoggedIn()) {
            startActivity(Intent(this, HomeActivity::class.java))
            finish()
        }

        setContentView(R.layout.activity_login)

        val email = findViewById<EditText>(R.id.etEmail)
        val password = findViewById<EditText>(R.id.etPassword)
        val loginBtn = findViewById<Button>(R.id.btnLogin)
        val register = findViewById<TextView>(R.id.tvRegister)
        val loginWithMobile = findViewById<TextView>(R.id.tvLoginWithMobile)
        val phone = findViewById<EditText>(R.id.etPhone)


        var isPasswordVisible = false

        password.setOnTouchListener { _, event ->
            if (event.action == android.view.MotionEvent.ACTION_UP) {

                // Detect click on drawableEnd
                if (event.rawX >= (password.right - password.compoundDrawables[2].bounds.width())) {

                    if (isPasswordVisible) {
                        // Hide password
                        password.inputType =
                            android.text.InputType.TYPE_CLASS_TEXT or
                                    android.text.InputType.TYPE_TEXT_VARIATION_PASSWORD
                        password.setCompoundDrawablesWithIntrinsicBounds(
                            0, 0, R.drawable.baseline_key_24, 0
                        )
                    } else {
                        // Show password
                        password.inputType =
                            android.text.InputType.TYPE_CLASS_TEXT or
                                    android.text.InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD
                        password.setCompoundDrawablesWithIntrinsicBounds(
                            0, 0, R.drawable.baseline_key_off_24, 0
                        )
                    }

                    password.setSelection(password.text.length)
                    isPasswordVisible = !isPasswordVisible
                    return@setOnTouchListener true
                }
            }
            false
        }

        var isMobileLogin = false

        loginWithMobile.setOnClickListener {

            isMobileLogin = !isMobileLogin

            if (isMobileLogin) {
                // Show phone login
                phone.visibility = android.view.View.VISIBLE
                email.visibility = android.view.View.GONE
                password.visibility = android.view.View.GONE

                loginWithMobile.text = "Log in with email & password"
                loginBtn.text = "Send OTP"
            } else {
                // Show email login
                phone.visibility = android.view.View.GONE
                email.visibility = android.view.View.VISIBLE
                password.visibility = android.view.View.VISIBLE

                loginWithMobile.text = "Log in with mobile number"
                loginBtn.text = "Login"
            }
        }

//        loginBtn.setOnClickListener {
//            RetrofitClient.api.login(
//                email.text.toString(),
//                password.text.toString()
//            ).enqueue(object : Callback<ApiResponse> {
//
//                override fun onResponse(
//                    call: Call<ApiResponse>,
//                    response: Response<ApiResponse>
//                ) {
//                    if (response.isSuccessful && response.body()?.success == true) {
//                        session.saveUser(response.body()!!.user!!)
//                        startActivity(Intent(this@Login, HomeActivity::class.java))
//                        finish()
//                    } else {
//                        toast("Invalid credentials")
//                        Log.d("fail","${response.toString()}")
//                    }
//                }
//
//                override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
//                    toast(t.message ?: "Network error")
//                }
//            })
//        }
        loginBtn.setOnClickListener {

            if (isMobileLogin) {
                //  MOBILE LOGIN → SEND OTP

                val mobile = phone.text.toString().trim()

                if (mobile.length != 10) {
                    toast("Enter valid mobile number")
                    return@setOnClickListener
                }

                RetrofitClient.api.loginWithMobile(mobile)
                    .enqueue(object : Callback<ApiResponse> {

                        override fun onResponse(
                            call: Call<ApiResponse>,
                            response: Response<ApiResponse>
                        ) {
                            if (response.isSuccessful && response.body()?.success == true) {

                                val intent = Intent(this@Login, LoginOtpVerifyActivity::class.java)
                                intent.putExtra("phone", mobile)
                                startActivity(intent)

                            } else {
                                toast(response.body()?.message ?: "Failed to send OTP")
                            }
                        }

                        override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
                            toast(t.message ?: "Network error")
                        }
                    })

            } else {
                //  EMAIL + PASSWORD LOGIN (existing)

                RetrofitClient.api.login(
                    email.text.toString(),
                    password.text.toString()
                ).enqueue(object : Callback<ApiResponse> {

                    override fun onResponse(
                        call: Call<ApiResponse>,
                        response: Response<ApiResponse>
                    ) {
                        if (response.isSuccessful && response.body()?.success == true) {
                            session.saveUser(response.body()!!.user!!)
//                            startActivity(Intent(this@Login, HomeActivity::class.java))
                            startActivity(Intent(this@Login, UserProfileActivity::class.java))
                            finish()
                        } else {
                            toast("Invalid credentials: ${response.body()!!.message}")
                        }
                    }

                    override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
                        toast(t.message ?: "Network error")
                    }
                })
            }
        }


        register.setOnClickListener {
            startActivity(Intent(this, RegisterActivity::class.java))
        }
    }

    private fun toast(msg: String) =
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show()
}
