package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.widget.Button
import android.widget.EditText
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.b2lmobitech.tundraplaynew.Login
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class LoginOtpVerifyActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_otp_verify)

        val session = SessionManager(this)
        val etOtp = findViewById<EditText>(R.id.etOtp)
        val btnVerify = findViewById<Button>(R.id.btnVerifyOtp)

        val phone = intent.getStringExtra("phone") ?: ""

        btnVerify.setOnClickListener {

            val otp = etOtp.text.toString().trim()

            if (otp.length != 4) {
                toast("Enter valid OTP")
                return@setOnClickListener
            }

            RetrofitClient.api.loginVerifyOtp(phone, otp)
                .enqueue(object : Callback<ApiResponse> {

                    override fun onResponse(
                        call: Call<ApiResponse>,
                        response: Response<ApiResponse>
                    ) {
                        if (response.isSuccessful && response.body()?.success == true) {
                            session.saveUser(response.body()!!.user!!)
                            startActivity(Intent(this@LoginOtpVerifyActivity, HomeActivity::class.java))
                            finish()
                        } else {
                            toast(response.body()?.message ?: "Invalid OTP")
                        }
                    }

                    override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
                        toast(t.message ?: "Network error")
                    }
                })
        }
    }

    private fun toast(msg: String) =
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show()
}
