package com.b2lmobitech.tundraplaynew

import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.ImageView
import androidx.recyclerview.widget.RecyclerView

class MovieAdapter(private val movies: List<Int>) :
    RecyclerView.Adapter<MovieAdapter.MovieVH>() {

    inner class MovieVH(val img: ImageView) : RecyclerView.ViewHolder(img)

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MovieVH {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_movie, parent, false)
        return MovieVH(view as ImageView)
    }

    override fun onBindViewHolder(holder: MovieVH, position: Int) {
        holder.img.setImageResource(movies[position])
    }

    override fun getItemCount() = movies.size
}
