package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.widget.ImageView
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.bumptech.glide.Glide
import com.google.android.material.button.MaterialButton

class MovieDetailsActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_movie_details)

        val movie = intent.getParcelableExtra<Movie>("MOVIE") ?: return

        val poster = findViewById<ImageView>(R.id.ivPoster)
        val title = findViewById<TextView>(R.id.tvTitle)
        val description = findViewById<TextView>(R.id.tvDescription)
        val releaseDate = findViewById<TextView>(R.id.tvReleaseDate)
        val language = findViewById<TextView>(R.id.tvLanguage)
        val playButton = findViewById<MaterialButton>(R.id.btnPlay)

        Glide.with(this)
            .asBitmap()
            .load(movie.poster_horizontal)
            .into(poster)

        title.text = movie.title
        description.text = movie.description
        releaseDate.text = "Release: ${movie.release_date}"
        language.text = "Language: ${movie.original_language}"

        playButton.setOnClickListener {
            val intent = Intent(this, PlayerActivity::class.java)
            intent.putExtra("DASH_URL", movie.dash_filepath)
            intent.putExtra("CID", movie.cid)
            intent.putExtra("CKEY", movie.ckey)
            startActivity(intent)
        }
    }
}
