package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.Button
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.text.SimpleDateFormat
import java.util.*

class ProfileActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_profile)

        val session = SessionManager(this)

        val tvName = findViewById<TextView>(R.id.tvName)
        val tvEmail = findViewById<TextView>(R.id.tvEmail)
        val tvPhone = findViewById<TextView>(R.id.tvPhone)
        val btnLogout = findViewById<Button>(R.id.btnLogout)
        val btnSubscription = findViewById<Button>(R.id.btnSubscription)
        val btnSwitchProfile = findViewById<Button>(R.id.btnSwitchProfile)
        val tvSubscription = findViewById<TextView>(R.id.tvSubscription)
        val tvProfileName = findViewById<TextView>(R.id.tvProfileName)

        tvName.text = session.getName()
        tvEmail.text = session.getEmail()
        tvPhone.text = session.getPhone()
        tvProfileName.text = session.getProfileName()
        Log.d("name","${tvProfileName.text}")

        btnSubscription.setOnClickListener {
            startActivity(Intent(this, SubscriptionActivity::class.java))
        }

        btnSwitchProfile.setOnClickListener {
            session.clearSelectedProfile()   // important
            startActivity(Intent(this, UserProfileActivity::class.java))
            finish()
        }

        btnLogout.setOnClickListener {
            session.logout()
            startActivity(Intent(this, Login::class.java))
            finishAffinity()
        }

        val btnSettings = findViewById<Button>(R.id.btnSettings)

        btnSettings.setOnClickListener {
            startActivity(Intent(this, SettingsActivity::class.java))
        }

        fetchUserSubscription(session.getUserId() ?: "", tvSubscription)
    }

    private fun fetchUserSubscription(userId: String, tvSubscription: TextView) {
        RetrofitClient.api.getUserById(userId).enqueue(object : Callback<UserResponse> {
            override fun onResponse(call: Call<UserResponse>, response: Response<UserResponse>) {
                if (response.isSuccessful && response.body() != null) {
                    val user = response.body()!!

                    if (!user.subscription_id.isNullOrEmpty()) {
                        val sdf = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())
                        val today = Date()
                        val start = sdf.parse(user.subs_start_date)
                        val end = sdf.parse(user.subs_end_date)

                        if (start != null && end != null && today in start..end) {
                            // Fetch subscription details
                            RetrofitClient.api.getSubscriptionById(user.subscription_id).enqueue(object: Callback<SubscriptionPlan>{
                                override fun onResponse(call: Call<SubscriptionPlan>, response: Response<SubscriptionPlan>) {
                                    if (response.isSuccessful && response.body() != null) {
                                        val subscription = response.body()!!
                                        tvSubscription.text = "Subscription: ${subscription.subscription_type}"
                                    } else {
                                        tvSubscription.text = "Subscription: None"
                                    }
                                }

                                override fun onFailure(call: Call<SubscriptionPlan>, t: Throwable) {
                                    tvSubscription.text = "Subscription: None"
                                }
                            })
                        } else {
                            tvSubscription.text = "Subscription: None"
                        }
                    } else {
                        tvSubscription.text = "Subscription: None"
                    }
                } else {
                    tvSubscription.text = "Subscription: None"
                }
            }

            override fun onFailure(call: Call<UserResponse>, t: Throwable) {
                tvSubscription.text = "Subscription: None"
            }
        })
    }
}
