package com.b2lmobitech.tundraplaynew

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView

class ProfileAdapter(
    private val profiles: List<UserProfile>,
    private val onClick: (UserProfile) -> Unit
) : RecyclerView.Adapter<ProfileAdapter.ProfileVH>() {

    inner class ProfileVH(view: View) : RecyclerView.ViewHolder(view) {
        val imgProfile: ImageView = view.findViewById(R.id.imgProfile)
        val txtName: TextView = view.findViewById(R.id.txtProfileName)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ProfileVH {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_profile, parent, false)
        return ProfileVH(view)
    }

    override fun onBindViewHolder(holder: ProfileVH, position: Int) {
        val profile = profiles[position]

        holder.txtName.text = profile.profile_name

        when {
            profile.isAdd -> {
                holder.imgProfile.setImageResource(R.drawable.ic_add)
            }

            profile.role.equals("kids", true) -> {
                holder.imgProfile.setImageResource(R.drawable.ic_kids)
            }

            else -> {
                holder.imgProfile.setImageResource(R.drawable.ic_profile)
            }
        }

        holder.itemView.setOnClickListener {
            onClick(profile)
        }
    }


    override fun getItemCount() = profiles.size
}
