package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.Button
import android.widget.EditText
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class RegisterActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_register)

        val name = findViewById<EditText>(R.id.etFullName)
        val email = findViewById<EditText>(R.id.etEmail)
        val phone = findViewById<EditText>(R.id.etPhone)
        val password = findViewById<EditText>(R.id.etPassword)
        val confirmPassword = findViewById<EditText>(R.id.etConfirmPassword)
        val btn = findViewById<Button>(R.id.btnRegister)

        var isPasswordVisible = false
        var isPasswordVisible2 = false

        password.setOnTouchListener { _, event ->
            if (event.action == android.view.MotionEvent.ACTION_UP) {

                // Detect click on drawableEnd
                if (event.rawX >= (password.right - password.compoundDrawables[2].bounds.width())) {

                    if (isPasswordVisible) {
                        // Hide password
                        password.inputType =
                            android.text.InputType.TYPE_CLASS_TEXT or
                                    android.text.InputType.TYPE_TEXT_VARIATION_PASSWORD
                        password.setCompoundDrawablesWithIntrinsicBounds(
                            0, 0, R.drawable.baseline_key_24, 0
                        )
                    } else {
                        // Show password
                        password.inputType =
                            android.text.InputType.TYPE_CLASS_TEXT or
                                    android.text.InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD
                        password.setCompoundDrawablesWithIntrinsicBounds(
                            0, 0, R.drawable.baseline_key_off_24, 0
                        )
                    }

                    password.setSelection(password.text.length)
                    isPasswordVisible = !isPasswordVisible
                    return@setOnTouchListener true
                }
            }
            false
        }

        confirmPassword.setOnTouchListener { _, event ->
            if (event.action == android.view.MotionEvent.ACTION_UP) {

                // Detect click on drawableEnd
                if (event.rawX >= (confirmPassword.right - confirmPassword.compoundDrawables[2].bounds.width())) {

                    if (isPasswordVisible2) {
                        // Hide password
                        confirmPassword.inputType =
                            android.text.InputType.TYPE_CLASS_TEXT or
                                    android.text.InputType.TYPE_TEXT_VARIATION_PASSWORD
                        confirmPassword.setCompoundDrawablesWithIntrinsicBounds(
                            0, 0, R.drawable.baseline_key_24, 0
                        )
                    } else {
                        // Show password
                        confirmPassword.inputType =
                            android.text.InputType.TYPE_CLASS_TEXT or
                                    android.text.InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD
                        confirmPassword.setCompoundDrawablesWithIntrinsicBounds(
                            0, 0, R.drawable.baseline_key_off_24, 0
                        )
                    }

                    confirmPassword.setSelection(confirmPassword.text.length)
                    isPasswordVisible2 = !isPasswordVisible2
                    return@setOnTouchListener true
                }
            }
            false
        }

        btn.setOnClickListener {
            RetrofitClient.api.register(
                name.text.toString(),
                email.text.toString(),
                phone.text.toString(),
                password.text.toString(),
                confirmPassword.text.toString()
            ).enqueue(object : Callback<ApiResponse> {

                override fun onResponse(
                    call: Call<ApiResponse>,
                    response: Response<ApiResponse>
                ) {
                    if (response.isSuccessful && response.body()?.success == true) {
                        Toast.makeText(this@RegisterActivity, "OTP sent to your phone", Toast.LENGTH_SHORT).show()

                        val intent = Intent(this@RegisterActivity, OtpVerifyActivity::class.java)
                        intent.putExtra("phone", phone.text.toString())
                        intent.putExtra("userid", response.body()?.user!!.id.toString())
                        startActivity(intent)

                        // optional: prevent going back
                        finish()

                    } else {
                        toast("Registration failed: ${response.body()!!.message}")
                        Log.d("fail","${response.toString()}")
                    }
                }

                override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
                    toast(t.message ?: "Network error")
                }
            })
        }
    }

    private fun toast(msg: String) =
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show()
}
