package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.widget.EditText
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import android.os.Handler
import android.os.Looper


class SearchActivity : AppCompatActivity() {

    private lateinit var etSearch: EditText
    private lateinit var rvSearch: RecyclerView
    private val movies = mutableListOf<Movie>()
    private lateinit var adapter: SearchMovieAdapter

    private var searchRunnable: Runnable? = null
    private val handler = Handler(Looper.getMainLooper())

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_search)

        etSearch = findViewById(R.id.etSearch)
        rvSearch = findViewById(R.id.rvSearch)

//        adapter = SearchMovieAdapter(movies)
        adapter = SearchMovieAdapter(movies) { movie ->
            val intent = Intent(this, MovieDetailsActivity::class.java)
            intent.putExtra("MOVIE", movie)
            startActivity(intent)
        }

        rvSearch.layoutManager = GridLayoutManager(this, 3)
        rvSearch.adapter = adapter

        etSearch.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable?) {}

            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                searchRunnable?.let { handler.removeCallbacks(it) }

                searchRunnable = Runnable {
                    val query = s.toString().trim()
                    if (query.length >= 2) {
                        searchMovies(query)
                    } else {
                        movies.clear()
                        adapter.notifyDataSetChanged()
                    }
                }
                handler.postDelayed(searchRunnable!!, 400)
            }
        })
    }

    private fun searchMovies(query: String) {
        RetrofitClient.api.searchMovies(query)
            .enqueue(object : Callback<List<Movie>> {
                override fun onResponse(
                    call: Call<List<Movie>>,
                    response: Response<List<Movie>>
                ) {
                    if (response.isSuccessful && response.body() != null) {
                        movies.clear()
                        movies.addAll(response.body()!!)
                        adapter.notifyDataSetChanged()
                    }

                }

                override fun onFailure(call: Call<List<Movie>>, t: Throwable) {}
            })
    }
}
