package com.b2lmobitech.tundraplaynew

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DecodeFormat
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.request.RequestOptions

class SearchMovieAdapter(
    private val list: List<Movie>,
    private val onClick: (Movie) -> Unit
) : RecyclerView.Adapter<SearchMovieAdapter.VH>() {

    inner class VH(view: View) : RecyclerView.ViewHolder(view) {
        val imgPoster: ImageView = view.findViewById(R.id.imgPoster)
        val tvTitle: TextView = view.findViewById(R.id.tvTitle)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): VH {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_search_movie, parent, false)
        return VH(view)
    }

    override fun onBindViewHolder(holder: VH, position: Int) {
        val movie = list[position]

        holder.tvTitle.text = movie.title

        Glide.with(holder.itemView.context)
            .load(movie.poster_vertical)
            .apply(
                RequestOptions()
                    .centerCrop()
                    .format(DecodeFormat.PREFER_RGB_565)
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .disallowHardwareConfig()
            )
            .into(holder.imgPoster)

        holder.itemView.setOnClickListener {
            onClick(movie)
        }
    }

    override fun getItemCount() = list.size
}
