package com.b2lmobitech.tundraplaynew

import android.content.Context

class SessionManager(context: Context) {

    private val prefs = context.getSharedPreferences("user_session", Context.MODE_PRIVATE)

    fun saveUser(user: User) {
        prefs.edit()
            .putBoolean("logged_in", true)
            .putString("id", user.id)
            .putString("name", user.name)
            .putString("email", user.email)
            .putString("phone", user.phone)
            .apply()
    }

    fun getSubscriptionId() = prefs.getString("subscription_id", "")
    fun getSubsStartDate() = prefs.getString("subs_start_date", "")
    fun getSubsEndDate() = prefs.getString("subs_end_date", "")


    fun getUserId() = prefs.getString("id", "")
    fun getName() = prefs.getString("name", "")
    fun getEmail() = prefs.getString("email", "")
    fun getPhone() = prefs.getString("phone", "")

    fun isLoggedIn(): Boolean =
        prefs.getBoolean("logged_in", false)

    fun logout() {
        prefs.edit().clear().apply()
    }
    fun saveSelectedProfile(profile: UserProfile) {
        prefs.edit().putString("profile_id", profile.profile_id)
        prefs.edit().putString("profile_name", profile.profile_name)
        prefs.edit().putString("profile_role", profile.role)
        prefs.edit().apply()
    }

    fun getProfileName() = prefs.getString("profile_name", "")
    fun getProfileId() = prefs.getString("profile_id", "")

    fun clearSelectedProfile() {
        prefs.edit().remove("profile_id")
        prefs.edit().remove("profile_name")
        prefs.edit().remove("profile_role")
        prefs.edit().apply()
    }


}
