package com.b2lmobitech.tundraplaynew

import android.os.Bundle
import android.widget.Button
import android.widget.RadioGroup
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity

class SettingsActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_settings)

        val prefs = getSharedPreferences("app_settings", MODE_PRIVATE)

        val rgMood = findViewById<RadioGroup>(R.id.rgMood)
        val rgTarget = findViewById<RadioGroup>(R.id.rgTarget)
        val rgViolence = findViewById<RadioGroup>(R.id.rgViolence)
        val btnSave = findViewById<Button>(R.id.btnSave)

        // Load saved values
        when (prefs.getString("mood", "dark")) {
            "dark" -> rgMood.check(R.id.rbDark)
            "light" -> rgMood.check(R.id.rbLight)
        }

        btnSave.setOnClickListener {
            val mood = if (rgMood.checkedRadioButtonId == R.id.rbLight) "light" else "dark"
            val target = findViewById<android.widget.RadioButton>(rgTarget.checkedRadioButtonId)?.text.toString()
            val violence = findViewById<android.widget.RadioButton>(rgViolence.checkedRadioButtonId)?.text.toString()

            prefs.edit()
                .putString("mood", mood)
                .putString("target", target)
                .putString("violence", violence)
                .apply()

            Toast.makeText(this, "Settings saved", Toast.LENGTH_SHORT).show()
            finish()
        }
    }
}
