package com.b2lmobitech.tundraplaynew

import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class SubscriptionActivity : AppCompatActivity() {

    private lateinit var rv: RecyclerView
    private lateinit var adapter: SubscriptionAdapter
    private val plans = mutableListOf<SubscriptionPlan>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_subscription)

        rv = findViewById(R.id.rvSubscriptions)
        rv.layoutManager = LinearLayoutManager(this)

        adapter = SubscriptionAdapter(plans) { plan ->
            subscribe(plan)
        }

        rv.adapter = adapter

        loadSubscriptions()
    }

    private fun loadSubscriptions() {
        RetrofitClient.api.getSubscriptions()
            .enqueue(object : Callback<SubscriptionResponse> {

                override fun onResponse(
                    call: Call<SubscriptionResponse>,
                    response: Response<SubscriptionResponse>
                ) {
                    if (response.isSuccessful && response.body()?.success == true) {

                        plans.clear()
                        plans.addAll(response.body()!!.subscriptions)
                        adapter.notifyDataSetChanged()

                    } else {
                        toast("No subscriptions available")
                    }
                }

                override fun onFailure(call: Call<SubscriptionResponse>, t: Throwable) {
                    toast("Failed to load plans")
                    Log.e("Subscription", t.message ?: "error")
                }
            })
    }


    private fun subscribe(plan: SubscriptionPlan) {
        val userId = SessionManager(this).getUserId()

        RetrofitClient.api.subscribeUser(
            userId.toString(),
            plan.subscription_id
        ).enqueue(object : Callback<ApiResponse> {
            override fun onResponse(
                call: Call<ApiResponse>,
                response: Response<ApiResponse>
            ) {
                if (response.body()?.success == true) {
                    toast("Subscribed Successfully 🎉")
                    finish()
                } else {
                    toast("Subscription failed")
                }
            }

            override fun onFailure(call: Call<ApiResponse>, t: Throwable) {
                toast("Server error")
            }
        })
    }

    private fun toast(msg: String) =
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show()
}
