package com.b2lmobitech.tundraplaynew

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView

class SubscriptionAdapter(
    private val list: List<SubscriptionPlan>,
    private val onClick: (SubscriptionPlan) -> Unit
) : RecyclerView.Adapter<SubscriptionAdapter.VH>() {

    inner class VH(view: View) : RecyclerView.ViewHolder(view) {
        val tvType: TextView = view.findViewById(R.id.tvType)
        val tvPrice: TextView = view.findViewById(R.id.tvPrice)
        val tvDetails: TextView = view.findViewById(R.id.tvDetails)
        val btnSubscribe: Button = view.findViewById(R.id.btnSubscribe)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): VH {
        val v = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_subscription, parent, false)
        return VH(v)
    }

    override fun onBindViewHolder(h: VH, p: Int) {
        val plan = list[p]

        h.tvType.text = plan.subscription_type
        h.tvPrice.text = "₹${plan.amount}"
        h.tvDetails.text =
            "Ads: ${plan.ads}\nDownloads: ${plan.downloads}\nDevices: ${plan.no_devices}\nValidity: ${plan.no_days} days"

        h.btnSubscribe.setOnClickListener { onClick(plan) }
    }

    override fun getItemCount() = list.size
}
