package com.b2lmobitech.tundraplaynew

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

class UserProfileActivity : AppCompatActivity() {

    private lateinit var adapter: ProfileAdapter
    private lateinit var rv: RecyclerView
    private val profiles = mutableListOf<UserProfile>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_user_profile)

        rv = findViewById(R.id.rvProfiles)
        rv.layoutManager = GridLayoutManager(this, 2)

        adapter = ProfileAdapter(profiles) { profile ->

            if (profile.isAdd) {
                // ➕ Add profile clicked
                startActivity(Intent(this, AddProfileActivity::class.java))
            } else {
                // 👤 Existing profile selected
                Log.d("profile", "$profile")
                SessionManager(this).saveSelectedProfile(profile)
                startActivity(Intent(this, HomeActivity::class.java))
                finish()
            }
        }


        rv.adapter = adapter

    }
    //        loadProfiles()
    override fun onResume() {
        super.onResume()
        loadProfiles()   //  Reload here
    }

    private fun loadProfiles() {
        val userId = SessionManager(this).getUserId()

        RetrofitClient.api.getUserProfiles(userId.toString())
            .enqueue(object : Callback<ProfileResponse> {

                override fun onResponse(
                    call: Call<ProfileResponse>,
                    response: Response<ProfileResponse>
                ) {
                    if (response.isSuccessful && response.body()?.success == true) {

                        profiles.clear()
                        profiles.addAll(response.body()!!.profiles)

                        // ➕ Add Profile button
                        profiles.add(
                            UserProfile(
                                id = -1,
                                profile_id = "",
                                profile_name = "Add Profile",
                                role = "",
                                isAdd = true
                            )
                        )

                        adapter.notifyDataSetChanged()
                    }
                }

                override fun onFailure(call: Call<ProfileResponse>, t: Throwable) {
                    toast("Failed to load profiles")
                }
            })
    }


    private fun toast(msg: String) =
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show()
}
